/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CCRSNetscapeServer.cpp,v 1.8 2000/07/10 22:04:59 dallen Exp $
____________________________________________________________________________*/

#include <string.h>

#include "pgpMem.h"
#include "pgpUtilities.h"
#include "pgpKeys.h"

#include "StPGPRefs.h"
#include "CCRSNetscapeServer.h"


// namespace {
		static const char *	kContentType	=	"application/octet-stream";

		static const char *	kDefaultNetscapePath	=	"/cgi-bin/pkiclient.exe";
		static const char * kDefaultNetscapeCRLPath	=	"/getCRL?op=getCRL&issuepoint=MasterCRL";

		static const char *	kDefaultMicrosoftPath	=	"/certsrv/mscep/mscep.dll";
		static const char * kDefaultMicrosoftCRLPath=	"/certsrv/certcrl.crl?Renewal=0&Enc=bin";
// }


CCRSNetscapeServer::CCRSNetscapeServer(
	PGPContextRef			inContext,
	const char *			inHostName,
	PGPUInt32				inHostAddress,
	PGPUInt16				inHostPort,
	const char *			inPath,
	PGPKeyServerProtocol	inProtocol,
	PGPKeyServerClass		inClass )
		: CCRSServer(inContext, inHostName, inHostAddress, inHostPort, inPath, inProtocol, inClass)
{
}



CCRSNetscapeServer::~CCRSNetscapeServer()
{
}



	void
CCRSNetscapeServer::SendCertificateRequest(
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inRequestKey,
	const void *	inBuffer,
	PGPSize			inBufferSize,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	(void) inRequestKey;
	(void) inCAKey;
	
	try {
		InitOperation();
		if (IsNull(inBuffer)) {
			ThrowPGPError_(kPGPError_OptionNotFound);
		}

		*outBufferSize = PostCRSMessage(kPGPKeyServerState_Uploading,
										(mPath == 0) ? 
											(mClass == kPGPKeyServerClass_Netscape ?
												kDefaultNetscapePath :
												kDefaultMicrosoftPath ) : 
											mPath,
										reinterpret_cast<PGPByte **>(outBuffer),
										inBufferSize,
										static_cast<const PGPByte *>(inBuffer));
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}



	void
CCRSNetscapeServer::RetrieveCertificate(
	PGPFilterRef	inSearchFilter,
	PGPKeyDBObjRef	inSearchKey,
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *		inPassphrase,
	PGPSize			inPassphraseLength,
	PGPBoolean		inIsPassphrase,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	(void) inSearchFilter;

	try {
		PackageAndSendCRSMessage(	kPGPExportFormat_NetscapeV1_GetCertInitial,
						kPGPOutputFormat_NetscapeV1_GetCertInitialInPKCS7,
						inSearchKey,
						inCAKey,
						inSigningKey,
						inPassphrase,
						inPassphraseLength,
						inIsPassphrase,
						outBuffer,
						outBufferSize);
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}



	void
CCRSNetscapeServer::RetrieveCRL(
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *		inPassphrase,
	PGPSize			inPassphraseLength,
	PGPBoolean		inIsPassphrase,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	(void) inCAKey;
	(void) inSigningKey;
	(void) inPassphrase;
	(void) inPassphraseLength;
	(void) inIsPassphrase;

	try {
		StPGPDataRef	result;
		PGPSize			resultSize;
		PGPByte			*getBuffer;
		PGPSize			getBufferLen;
		PGPMemoryMgrRef	mgr			= PGPPeekContextMemoryMgr (mContext);
		char *			path		= (mPath == 0) ? 
										(mClass == kPGPKeyServerClass_Netscape ?
											(char *) kDefaultNetscapeCRLPath :
											(char *) kDefaultMicrosoftCRLPath ) : 
										mPath;

		getBufferLen = strlen( path ) + 1;
		getBuffer = (PGPByte*)PGPNewData (mgr, getBufferLen, 0);

		strcpy ((char*)getBuffer, path);

		// CHTTPKeyServer::GetPost called with inData == 0 causes it to do
		// a HTTP GET rather than POST
		resultSize = GetPost( 
			kPGPKeyServerState_Querying,
			(char*)getBuffer, 
			&result, 
			kContentType, 
			0, 0 );
		CheckAndRemoveHTTPHeader( result,
			resultSize, 
			(unsigned char **) outBuffer, 
			outBufferSize );

		PGPFreeData (getBuffer);
		result.Free();
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}


// this is a misnomer, we actually do a HTTP GET for Netscape
	PGPUInt32
CCRSNetscapeServer::PostCRSMessage(
	PGPKeyServerState	inOperation,
	const char *		inPath,
	PGPByte**		outResult,
	PGPUInt32		inContentLength,
	const PGPByte *		inData)
{
	StPGPDataRef	result;
	PGPSize		resultSize;
	PGPByte		*encodedData;
	PGPByte		*urlBuffer;
	PGPByte		*getBuffer;
	PGPSize		encodedDataLen;
	PGPSize		urlBufferLen;
	PGPSize		getBufferLen;
	PGPMemoryMgrRef	mgr = PGPPeekContextMemoryMgr (mContext);
	PGPSize		i;

	// allocate enough space for the base64 encoded result
	encodedData = (PGPByte *) PGPNewData (mgr, ( ( (inContentLength / 3) + 1 ) * 4 ) + 1, 0);
	encodedDataLen = Base64Encode (inData, inContentLength, (char*)encodedData, 0);
	// since the message is part of the URL, we have to encode it
	// first scan the buffer to see how much extra space we need
	urlBufferLen = encodedDataLen;
	for (i = 0; i < encodedDataLen; i++)
	{
		if (encodedData[i] == '+' || encodedData[i] == '=' ||
			encodedData[i] == '/')
			urlBufferLen += 2;
	}
	urlBuffer = (PGPByte *) PGPNewData (mgr, urlBufferLen+1, 0);
	urlBufferLen = URLEncode ((char*)encodedData, encodedDataLen, (char*)urlBuffer);
	// now form the proper URL
	getBufferLen = urlBufferLen + strlen (inPath) + sizeof ("?operation=PKIOperation&message=");
	getBuffer = (PGPByte*)PGPNewData (mgr, getBufferLen, 0);
	strcpy ((char*)getBuffer, inPath);
	strcat ((char*)getBuffer, "?operation=PKIOperation&message=");
	getBuffer[strlen((char*)getBuffer) + urlBufferLen] = 0; // nul terminate string
	memcpy (getBuffer + strlen ((char*)getBuffer), urlBuffer, urlBufferLen);
	PGPFreeData (urlBuffer);
	PGPFreeData (encodedData);

	// CHTTPKeyServer::GetPost called with inData == 0 causes it to do
	// a HTTP GET rather than POST
	resultSize = GetPost(inOperation, (char*)getBuffer, &result, kContentType, 0, 0);
	CheckAndRemoveHTTPHeader(result, resultSize, outResult, &resultSize);

	PGPFreeData (getBuffer);
	result.Free();

	return resultSize;
}



	void
CCRSNetscapeServer::PackageAndSendCRSMessage(
	PGPExportFormat	inExportFormat,
	PGPOutputFormat	inOutputFormat,
	PGPKeyDBObjRef	inKey,
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *	inPassphrase,
	PGPSize		inPassphraseLength,
	PGPBoolean	inIsPassphrase,
	void **		outBuffer,
	PGPSize *	outBufferSize)
{
	PGPError	pgpErr;
	StPGPDataRef	buffer;
	PGPSize		bufSize;
	StPGPDataRef	crsMessage;
	PGPSize		crsMessageSize;
	
	InitOperation();
	if (! PGPKeyDBObjRefIsValid(inKey)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	if (! PGPKeyDBObjRefIsValid(inSigningKey)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	if (! PGPKeyDBObjRefIsValid(inCAKey)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	if (IsNull(inPassphrase)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	
	pgpErr = PGPExport(	mContext,
				PGPOExportKeyDBObj( mContext, inKey ),
				PGPOExportFormat(mContext, inExportFormat),
				PGPOAllocatedOutputBuffer(mContext,
					(void **) &buffer,
					MAX_PGPSize,
					&bufSize),
				PGPOLastOption(mContext));
	ThrowIfPGPError_(pgpErr);
	pgpErr = PGPEncode(	mContext,
				PGPOSignWithKey(mContext, inSigningKey,
					(inIsPassphrase) ? PGPOPassphraseBuffer(mContext, inPassphrase, inPassphraseLength) :
						PGPOPasskeyBuffer(mContext, inPassphrase, inPassphraseLength), PGPOLastOption(mContext)),
				PGPOEncryptToKeyDBObj (mContext, inCAKey),
				PGPOInputBuffer(mContext, static_cast<PGPByte *>(buffer), bufSize),
				PGPOAllocatedOutputBuffer(mContext, (void **) &crsMessage, MAX_PGPSize, &crsMessageSize),
				PGPOOutputFormat(mContext, inOutputFormat),
				PGPOLastOption(mContext));
	ThrowIfPGPError_(pgpErr);
	buffer.Free();
	*outBufferSize = PostCRSMessage(kPGPKeyServerState_Querying,
		(mPath == 0) ? 
			(mClass == kPGPKeyServerClass_Netscape ?
				kDefaultNetscapePath :
				kDefaultMicrosoftPath ) : 
			mPath,
		reinterpret_cast<PGPByte **>(outBuffer),
		crsMessageSize,
		static_cast<const PGPByte *>(crsMessage));

	crsMessage.Free();
}
